//  Copyright (c) 2009 Karl Blomster
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy
//  of this software and associated documentation files (the "Software"), to deal
//  in the Software without restriction, including without limitation the rights
//  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//  copies of the Software, and to permit persons to whom the Software is
//  furnished to do so, subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in
//  all copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//  THE SOFTWARE.


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdint.h>
#include <stdio.h>
extern "C" {
#	include <ass/ass.h>
#	include <ass/ass_types.h>
}
#include "avisynth.h"



class AssRender : public GenericVideoFilter {   
private:
	struct logprivate {
		int		loglevel;
		FILE	*log;
	} lp;

	bool InitLibass(ASS_Hinting hints, double scale);

	ASS_Library *al;
	ASS_Renderer *ar;
	ASS_Track *t;

public:
	AssRender(PClip _child, const char *_filename, ASS_Hinting hints, double scale,
		const char *charset, int loglevel, std::string logfile, IScriptEnvironment* env);
	~AssRender();

	static void __cdecl LoggingCallback(int level, const char *fmt, va_list args, void *data);

	PVideoFrame __stdcall GetFrame(int n, IScriptEnvironment* env);
};
